/*
 * ContagionStatistics.cpp
 *
 *  Created on: 1. 12. 2013.
 *      Author: Korisnik
 */

#include <ContagionStatistics.h>

void init_statistic_parameters(const long int nrow, const long int ncol, input * input_args, infected_structure * p_infected_parameters, statistics *statistic_parameters) {

    // initialisation
    // all values are zero except for rang_int which is 1 -> epidemic isn't spreaded globaly


    igraph_matrix_init(&(statistic_parameters->mean), nrow, ncol);
    igraph_matrix_init(&(statistic_parameters->std), nrow, ncol);
    //igraph_matrix_init(&(statistic_parameters->mean_range), nrow, ncol);
    //igraph_matrix_init(&(statistic_parameters->std_range), nrow, ncol);
    //igraph_matrix_init(&(statistic_parameters->range_int), nrow, ncol);
    //igraph_matrix_fill(&(statistic_parameters->range_int), 1);


    statistic_parameters->no_of_iteration_per_cycle = input_args->no_of_iteration_per_cycle;
    statistic_parameters->no_of_init_cycles = input_args->no_of_cycles;
    statistic_parameters->epsilon = input_args->epsilon;
    //igraph_matrix_init(&(statistic_parameters->ranges_from_start_node), 1, p_infected_parameters->no_of_nodes);
    //igraph_shortest_paths(p_infected_parameters->p_graph, &(statistic_parameters->ranges_from_start_node), igraph_vss_1((igraph_integer_t) p_infected_parameters->start_node), IGRAPH_ALL);


    //statistic_parameters->diameter = igraph_matrix_max(&(statistic_parameters->ranges_from_start_node));

    //igraph_vector_init(&(statistic_parameters->range_distribution), (long int) statistic_parameters->diameter + 1);
    igraph_vector_init(&(statistic_parameters->recovered_nodes), p_infected_parameters->no_of_nodes);
    //igraph_vector_init(&(statistic_parameters->percent_recovered), p_infected_parameters->no_of_nodes);
    //igraph_vector_init(&(statistic_parameters->relative_no_of_recovered), statistic_parameters->no_of_iteration_per_cycle);

    //igraph_vector_init(&(statistic_parameters->relative_epidemic_range), statistic_parameters->no_of_iteration_per_cycle);
    igraph_vector_t * realization_observed = (igraph_vector_t*) malloc (sizeof(igraph_vector_t)); // *** HEAP MEMORY SAFE
    igraph_vector_init ( realization_observed, p_infected_parameters->no_of_nodes);
    statistic_parameters->observed_realization = realization_observed;

    statistic_parameters->detectability_mat = NULL;
    statistic_parameters->detectability_mat_square = NULL;
    statistic_parameters->likelihoodAll = NULL;

}

void init_static_parameters_detectability(infected_structure * p_infected_parameters, statistics *statistic_parameters){
	igraph_spmatrix_t * detectability_mat = (igraph_spmatrix_t *) malloc(sizeof(igraph_spmatrix_t));
	igraph_spmatrix_init( detectability_mat, p_infected_parameters->no_of_nodes, p_infected_parameters->no_of_nodes);
	statistic_parameters->detectability_mat = detectability_mat;

	igraph_spmatrix_t * detectability_mat_square = (igraph_spmatrix_t *) malloc(sizeof(igraph_spmatrix_t));
	igraph_spmatrix_init( detectability_mat_square, p_infected_parameters->no_of_nodes, p_infected_parameters->no_of_nodes);
	statistic_parameters->detectability_mat_square = detectability_mat_square;
}

void destroy_statistic_parameters(statistics *statistic_parameters) {
    igraph_matrix_destroy(&(statistic_parameters->mean));
    igraph_matrix_destroy(&(statistic_parameters->std));
    //igraph_matrix_destroy(&(statistic_parameters->mean_range));
    //igraph_matrix_destroy(&(statistic_parameters->std_range));
    //igraph_matrix_destroy(&(statistic_parameters->range_int));
    igraph_vector_destroy(&(statistic_parameters->recovered_nodes));

    // statistic_parameters->mask is destroyed dynamically in loops
    // statistic_parameters->observed_realization is destroyed dynamically in loops

    /*
     *check why this is not destroyed in a proper way, maybe only workers have this ??
    if (statistic_parameters->detectability_mat != NULL){
    	igraph_spmatrix_destroy( statistic_parameters->detectability_mat );
    }

    if(statistic_parameters->detectability_mat_square != NULL){
    	igraph_spmatrix_destroy( statistic_parameters->detectability_mat_square );
    }

	// only collector has this variable
    if ( statistic_parameters->likelihoodAll != NULL){
    	free(statistic_parameters->likelihoodAll);
    }
    */

    //igraph_vector_destroy(&(statistic_parameters->percent_recovered));
    //igraph_vector_destroy(&(statistic_parameters->relative_no_of_recovered));
    //igraph_vector_destroy(&(statistic_parameters->relative_epidemic_range));
    //igraph_matrix_destroy(&(statistic_parameters->ranges_from_start_node));
    //igraph_vector_destroy(&(statistic_parameters->range_distribution));

}

void update_detectability_matrices(statistics *statistic_parameters, double * likelihoodsAll, infected_structure * p_infected_parameters){
	//update detectability matrix E(X_{ij}) and E(X_{ij}^2)  for each realization ; X_{ij} = P(I = i | R)|I=j

	double sum_prob = 0.0;
	for (int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		sum_prob += likelihoodsAll[i];
	}

	long int source_j = (long int) p_infected_parameters->start_node;

	if (sum_prob != 0.0){
		for (long int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
			// E(X)
			double D_old = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat, i , source_j);
			double prob_i = likelihoodsAll[i] / sum_prob;
			double D_tmp = D_old + prob_i;
			igraph_spmatrix_set( statistic_parameters->detectability_mat, i , source_j, (igraph_real_t) D_tmp );

			//E(X^2)
			double D_old_square = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat_square, i , source_j);
			double D_tmp_square = D_old_square + (prob_i*prob_i);
			igraph_spmatrix_set( statistic_parameters->detectability_mat_square, i , source_j, (igraph_real_t) D_tmp_square);
		}
	}
}

void update_detectability_matrices_by_def(statistics *statistic_parameters, double * likelihoodsAll, infected_structure * p_infected_parameters){
	//update detectability matrix E(X_{ij}) and E(X_{ij}^2)  for each realization ; X_{ij} = P(I = i | R)|I=j
	// by definition D(i|j) = \sum_r P(I = i | r ) P( r | j)

	double sum_prob = 0.0;
	for (int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		sum_prob += likelihoodsAll[i];
	}
	statistic_parameters->det_matrix_is_normalized = 1;

	long int source_j = (long int) p_infected_parameters->start_node;

	if (sum_prob != 0.0){
		for (long int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
			// E(X)
			double D_old = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat, i , source_j);
			double prob_i = likelihoodsAll[i] / sum_prob;
			double prob_r_j = likelihoodsAll[source_j];
			double D_tmp = D_old + prob_i*prob_r_j;
			igraph_spmatrix_set( statistic_parameters->detectability_mat, i , source_j, (igraph_real_t) D_tmp );

			//E(X^2)
			double D_old_square = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat_square, i , source_j);
			double D_tmp_square = D_old_square + (prob_i*prob_i*prob_r_j*prob_r_j); // not so sure !!!
			igraph_spmatrix_set( statistic_parameters->detectability_mat_square, i , source_j, (igraph_real_t) D_tmp_square);
		}
	}
}

void normalize_detectabilty_matrix(statistics *statistic_parameters, int num_real_per_source){

	if ( statistic_parameters->det_matrix_is_normalized == 0 ){
		double scale_num = (double) 1.0 / (double) num_real_per_source;
		igraph_spmatrix_scale( statistic_parameters->detectability_mat, (igraph_real_t) scale_num );
		igraph_spmatrix_scale( statistic_parameters->detectability_mat_square, (igraph_real_t) scale_num );
		statistic_parameters->det_matrix_is_normalized = 1;
	}

}

void print_detectabilty_matrix(statistics *statistic_parameters, infected_structure * p_infected_parameters){
	//slow !!! only for testing

	if ( statistic_parameters->det_matrix_is_normalized == 0 ){
		printf("Detectability matrices not normalized ! \n");
		return;
	}


	printf("\n *** Detectability matrix *** \n");
	for (int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		for (int j = 0; j< p_infected_parameters->no_of_nodes; ++j){
			double tmp_val = (double) igraph_spmatrix_e(statistic_parameters->detectability_mat, i,j);
			printf("%lf ", tmp_val);
		}
		printf("\n");
	}

}

void print_detectabilty_matrix_VAR(statistics *statistic_parameters, infected_structure * p_infected_parameters){
	//slow !!! only for testing

	if ( statistic_parameters->det_matrix_is_normalized == 0 ){
		printf("Detectability matrices not normalized ! \n");
		return;
	}


	printf("\n *** Detectability VAR matrix *** \n");
	for (int i = 0; i< p_infected_parameters->no_of_nodes; ++i){
		for (int j = 0; j< p_infected_parameters->no_of_nodes; ++j){
			double tmp_val = (double) igraph_spmatrix_e(statistic_parameters->detectability_mat_square, i,j);
			printf("%lf ", tmp_val);
		}
		printf("\n");
	}

}

void print_E_V_detectabilty_matrix_diagonal(statistics *statistic_parameters, vector<int> * source_array_id){

	if ( statistic_parameters->det_matrix_is_normalized == 0 ){
			printf("Detectability matrices not normalized ! \n");
			return;
	}

	printf("\n *** Detectability elements D(i,i): *** \n");
	for(int source_idx = 0; source_idx< source_array_id->size(); source_idx++){
		int source_node = source_array_id->at(source_idx);
		double E_val = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat , source_node, source_node);
		double E_val_square = (double) igraph_spmatrix_e( statistic_parameters->detectability_mat_square, source_node, source_node);
		printf("SOURCE %d E(X) %lf , Var(X) %lf \n", source_node, E_val, E_val_square );
	}
}

double get_detectability_element(statistics *statistic_parameters, long int node_i, long int node_j){
	double tmp_val = (double) igraph_spmatrix_e(statistic_parameters->detectability_mat, node_i, node_j);
	return tmp_val;
}

double get_detectability_VAR_element(statistics *statistic_parameters, long int node_i, long int node_j){
	double tmp_val = (double) igraph_spmatrix_e(statistic_parameters->detectability_mat_square, node_i, node_j);
	return tmp_val;
}

void free_mask_in_statistics_struct(statistics * statistic_parameters){

	if ((statistic_parameters->use_mask == 1)&&(statistic_parameters->mask != NULL)){
		igraph_vector_destroy(statistic_parameters->mask);
		statistic_parameters->mask == NULL;
	}
}
